#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for all tag names
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.03';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo);

#
# Note: the tables below are generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

my @tableList = (
    'Image::ExifTool::Canon::CameraSettings',
    'Image::ExifTool::Canon::ColorInfo',
    'Image::ExifTool::Canon::ColorInfoD30',
    'Image::ExifTool::Canon::FileInfo',
    'Image::ExifTool::Canon::FocalLength',
    'Image::ExifTool::Canon::Main',
    'Image::ExifTool::Canon::PictureInfo',
    'Image::ExifTool::Canon::PreviewImageInfo',
    'Image::ExifTool::Canon::ShotInfo',
    'Image::ExifTool::Canon::WhiteBalance',
    'Image::ExifTool::CanonCustom::Functions10D',
    'Image::ExifTool::CanonCustom::Functions1D',
    'Image::ExifTool::CanonCustom::Functions20D',
    'Image::ExifTool::CanonCustom::FunctionsD30',
    'Image::ExifTool::CanonRaw::ExposureInfo',
    'Image::ExifTool::CanonRaw::FlashInfo',
    'Image::ExifTool::CanonRaw::ImageFormat',
    'Image::ExifTool::CanonRaw::ImageInfo',
    'Image::ExifTool::CanonRaw::Main',
    'Image::ExifTool::CanonRaw::MakeModel',
    'Image::ExifTool::CanonRaw::SensorInfo',
    'Image::ExifTool::CanonRaw::TimeStamp',
    'Image::ExifTool::Casio::Main',
    'Image::ExifTool::Casio::Type2',
    'Image::ExifTool::Exif::Main',
    'Image::ExifTool::FujiFilm::Main',
    'Image::ExifTool::GPS::Main',
    'Image::ExifTool::GeoTiff::Main',
    'Image::ExifTool::ICC_Profile::Chromaticity',
    'Image::ExifTool::ICC_Profile::ColorantTable',
    'Image::ExifTool::ICC_Profile::Header',
    'Image::ExifTool::ICC_Profile::Main',
    'Image::ExifTool::ICC_Profile::Measurement',
    'Image::ExifTool::ICC_Profile::ViewingConditions',
    'Image::ExifTool::IPTC::ApplicationRecord',
    'Image::ExifTool::IPTC::EnvelopeRecord',
    'Image::ExifTool::IPTC::Main',
    'Image::ExifTool::IPTC::NewsPhoto',
    'Image::ExifTool::IPTC::ObjectData',
    'Image::ExifTool::IPTC::PostObjectData',
    'Image::ExifTool::IPTC::PreObjectData',
    'Image::ExifTool::Jpeg2000::CaptureResolution',
    'Image::ExifTool::Jpeg2000::DisplayResolution',
    'Image::ExifTool::Jpeg2000::ImageHeader',
    'Image::ExifTool::Jpeg2000::Main',
    'Image::ExifTool::Kodak::Borders',
    'Image::ExifTool::Kodak::Main',
    'Image::ExifTool::Kodak::SpecialEffects',
    'Image::ExifTool::Kodak::Type2',
    'Image::ExifTool::Kodak::Type3',
    'Image::ExifTool::Kodak::Type4',
    'Image::ExifTool::Kodak::Type5',
    'Image::ExifTool::Kodak::Type6',
    'Image::ExifTool::Kodak::Unknown',
    'Image::ExifTool::MIFF::Main',
    'Image::ExifTool::Minolta::CameraSettings',
    'Image::ExifTool::Minolta::Main',
    'Image::ExifTool::Nikon::ColorBalance0100',
    'Image::ExifTool::Nikon::ColorBalance0102',
    'Image::ExifTool::Nikon::ColorBalance0103',
    'Image::ExifTool::Nikon::LensData00',
    'Image::ExifTool::Nikon::LensData01',
    'Image::ExifTool::Nikon::Main',
    'Image::ExifTool::Nikon::MakerNotesB',
    'Image::ExifTool::Nikon::NikonCaptureOffsets',
    'Image::ExifTool::Nikon::PreviewImage',
    'Image::ExifTool::Olympus::CameraSettings',
    'Image::ExifTool::Olympus::Equipment',
    'Image::ExifTool::Olympus::FocusInfo',
    'Image::ExifTool::Olympus::ImageProcessing',
    'Image::ExifTool::Olympus::Main',
    'Image::ExifTool::Olympus::RawDevelopment',
    'Image::ExifTool::PNG::ImageHeader',
    'Image::ExifTool::PNG::Main',
    'Image::ExifTool::PNG::PhysicalPixel',
    'Image::ExifTool::PNG::PrimaryChromaticities',
    'Image::ExifTool::PNG::TextualData',
    'Image::ExifTool::Panasonic::Main',
    'Image::ExifTool::Pentax::Main',
    'Image::ExifTool::Photoshop::JPEG_Quality',
    'Image::ExifTool::Photoshop::Main',
    'Image::ExifTool::PrintIM::Main',
    'Image::ExifTool::Ricoh::Main',
    'Image::ExifTool::Ricoh::Subdir',
    'Image::ExifTool::Ricoh::Text',
    'Image::ExifTool::Sanyo::Main',
    'Image::ExifTool::Sigma::Main',
    'Image::ExifTool::Sony::Main',
    'Image::ExifTool::Unknown::Main',
    'Image::ExifTool::XMP::Main',
    'Image::ExifTool::compositeTags',
    'Image::ExifTool::extraTags',
);

my %tagLookup = (
    'actionadvised' => { 34 => 0x2a },
    'addoriginaldecisiondata' => { 12 => 0x11 },
    'adjustmentmode' => { 86 => 0x15 },
    'advisory' => { 89 => 'Advisory' },
    'aebbracketvalue' => { 8 => 0x11 },
    'aebsequence' => { 10 => 0x9, 11 => 0x9, 12 => 0x8, 13 => 0x7 },
    'afaperture' => { 61 => 0x5 },
    'afareas' => { 66 => 0x304 },
    'afassist' => { 10 => 0x5, 13 => 0x5 },
    'afassistbeam' => { 12 => 0x4 },
    'afmode' => { 86 => 0x5 },
    'afpoint' => { 0 => 0x13, 62 => 0x88 },
    'afpointactivationarea' => { 11 => 0x11 },
    'afpointillumination' => { 11 => 0xa },
    'afpointregistration' => { 10 => 0x7 },
    'afpointselection' => { 11 => 0xb },
    'afpointselectionmethod' => { 12 => 0xc },
    'afpointspotmetering' => { 11 => 0xd },
    'afpointsused' => { 6 => 0x16 },
    'afsearch' => { 66 => 0x303 },
    'aiservotrackingsensitivity' => { 11 => 0x14 },
    'aliaslayermetadata' => { 24 => 0xc660 },
    'alphachannelsnames' => { 80 => 0x3ee },
    'alphaidentifiers' => { 80 => 0x41d },
    'analogbalance' => { 24 => 0xc627 },
    'analogzoom' => { 49 => 0x1e },
    'annotations' => { 24 => 0xc44f },
    'antialiasstrength' => { 24 => 0xc632 },
    'aperture' => { 90 => 'Aperture' },
    'aperturevalue' => { 24 => 0x9202, 89 => 'ApertureValue' },
    'applicationnotes' => { 24 => 0x2bc },
    'applicationrecordversion' => { 34 => 0x0 },
    'armidentifier' => { 35 => 0x78 },
    'armversion' => { 35 => 0x7a },
    'artist' => { 24 => 0x13b, 89 => 'Artist' },
    'asshotneutral' => { 24 => 0xc628 },
    'asshotwhitexy' => { 24 => 0xc629 },
    'assistbuttonfunction' => { 10 => 0xd },
    'association' => { 44 => 'asoc' },
    'atob0' => { 31 => 'A2B0' },
    'atob1' => { 31 => 'A2B1' },
    'atob2' => { 31 => 'A2B2' },
    'audio' => { 77 => 0x20 },
    'audioduration' => { 34 => 0x99 },
    'audiooutcue' => { 34 => 0x9a },
    'audiosamplingrate' => { 34 => 0x97 },
    'audiosamplingresolution' => { 34 => 0x98 },
    'audiotype' => { 34 => 0x96 },
    'author' => { 76 => 'Author', 89 => 'Author' },
    'authorsposition' => { 89 => 'AuthorsPosition' },
    'autoafpoint' => { 78 => 0xf },
    'autobracket' => { 86 => 0x19 },
    'autobracketing' => { 25 => 0x1100 },
    'autoexposurebracketing' => { 8 => 0x10 },
    'autofocus' => { 68 => 0x209 },
    'autorotate' => { 8 => 0x1b },
    'auxiliarylens' => { 62 => 0x82 },
    'avvalue' => { 14 => 0x2 },
    'backgroundcolor' => { 54 => 'background-color', 80 => 0x3f2 },
    'backgroundcolorindicator' => { 24 => 0x84e8 },
    'backgroundcolorvalue' => { 24 => 0x84ea },
    'badfaxlines' => { 24 => 0x146 },
    'baseiso' => { 18 => 0x101c },
    'baselineexposure' => { 24 => 0xc62a },
    'baselinenoise' => { 24 => 0xc62b },
    'baselinesharpness' => { 24 => 0xc62c },
    'baseurl' => { 89 => 'BaseURL' },
    'batterylevel' => { 24 => 0x828f },
    'bayergreensplit' => { 24 => 0xc62d },
    'bestqualityscale' => { 24 => 0xc65c },
    'bestshotmode' => { 23 => 0x3007 },
    'binaryfilter' => { 44 => 'bfil' },
    'bitdepth' => { 72 => 0x8 },
    'bitspercomponent' => { 37 => 0x87, 43 => 0xa, 44 => 'bpcc' },
    'bitsperextendedrunlength' => { 24 => 0x84e5 },
    'bitsperrunlength' => { 24 => 0x84e4 },
    'bitspersample' => { 24 => 0x102, 89 => 'BitsPerSample' },
    'blacklevel' => { 24 => 0xc61a, 70 => 0x1012 },
    'blackleveldeltah' => { 24 => 0xc61b },
    'blackleveldeltav' => { 24 => 0xc61c },
    'blacklevelrepeatdim' => { 24 => 0xc619 },
    'blackpoint' => { 78 => 0x200 },
    'bluebalance' => { 57 => 0x1, 58 => 0x1, 59 => 0x1, 70 => 0x1018, 78 => 0x1b },
    'bluebalanceauto' => { 9 => 0x1 },
    'bluebalanceb&w' => { 9 => 0xf },
    'bluebalancecloudy' => { 9 => 0x5 },
    'bluebalancecustom' => { 9 => 0xd },
    'bluebalancedaylight' => { 9 => 0x3 },
    'bluebalanceflash' => { 9 => 0xb },
    'bluebalancefluorescent' => { 9 => 0x9 },
    'bluebalanceshade' => { 9 => 0x11 },
    'bluebalancetungsten' => { 9 => 0x7 },
    'bluegain' => { 84 => 'Bg' },
    'bluehue' => { 89 => 'BlueHue' },
    'bluematrixcolumn' => { 31 => 'bXYZ' },
    'blueprimary' => { 54 => 'blue-primary' },
    'bluesaturation' => { 89 => 'BlueSaturation' },
    'bluetrc' => { 31 => 'bTRC' },
    'bluex' => { 75 => 0x6 },
    'bluey' => { 75 => 0x7 },
    'blurwarning' => { 25 => 0x1300 },
    'bodyfirmwareversion' => { 67 => 0x104 },
    'bordercolor' => { 54 => 'border-color' },
    'borderid' => { 45 => 0x2 },
    'borderinformation' => { 80 => 0x3f1 },
    'borderlocation' => { 45 => 0x3 },
    'bordername' => { 45 => 0x1 },
    'bordersversion' => { 45 => 0x0 },
    'bordertype' => { 45 => 0x4 },
    'bracket' => { 70 => 0x1006 },
    'bracketstep' => { 55 => 0xe },
    'brightness' => { 24 => 0xfe53, 55 => 0x2c, 89 => 'Brightness' },
    'brightnessvalue' => { 24 => 0x9203, 89 => 'BrightnessValue' },
    'btoa0' => { 31 => 'B2A0' },
    'btoa1' => { 31 => 'B2A1' },
    'btoa2' => { 31 => 'B2A2' },
    'bulbduration' => { 8 => 0x18 },
    'burstmode' => { 46 => 0xa },
    'burstmode2' => { 46 => 0x18 },
    'bw_halftoninginfo' => { 80 => 0x3f4 },
    'bw_transferfunc' => { 80 => 0x3f7 },
    'bwfilter' => { 55 => 0x2a },
    'bwmode' => { 70 => 0x203 },
    'by-line' => { 34 => 0x50 },
    'by-linetitle' => { 34 => 0x55 },
    'calibrationdatetime' => { 31 => 'calt' },
    'calibrationilluminant1' => { 24 => 0xc65a },
    'calibrationilluminant2' => { 24 => 0xc65b },
    'cameracalibration1' => { 24 => 0xc623 },
    'cameracalibration2' => { 24 => 0xc624 },
    'cameraid' => { 70 => 0x209, 85 => 0x209 },
    'cameraiso' => { 0 => 0x10 },
    'cameraobject' => { 18 => 0x2807 },
    'cameraowner' => { 24 => 0xc353 },
    'camerasettings' => { 70 => 0x2020 },
    'camerasettingsversion' => { 66 => 0x0 },
    'cameraspecification' => { 18 => 0x3004 },
    'canoncamerasettings' => { 5 => 0x1, 18 => 0x102d },
    'canoncolorinfo' => { 5 => 0xa0 },
    'canoncolorinfo1' => { 18 => 0x32 },
    'canoncolorinfo2' => { 18 => 0x102c },
    'canoncolorinfod30' => { 5 => 0xa },
    'canoncustomfunctions10d' => { 5 => 0xf, 18 => 0x1033 },
    'canoncustomfunctions1d' => { 5 => 0x90 },
    'canoncustomfunctions20d' => { 5 => 0xf, 18 => 0x1033 },
    'canoncustomfunctionsd30' => { 5 => 0xf, 18 => 0x1033 },
    'canonexposuremode' => { 0 => 0x14 },
    'canonfiledescription' => { 18 => 0x805 },
    'canonfileinfo' => { 5 => 0x93 },
    'canonfilelength' => { 5 => 0xe },
    'canonfirmwareversion' => { 5 => 0x7, 18 => 0x80b },
    'canonflashmode' => { 0 => 0x4 },
    'canonfocallength' => { 5 => 0x2, 18 => 0x1029 },
    'canonimageheight' => { 6 => 0x3 },
    'canonimageheightasshot' => { 6 => 0x5 },
    'canonimagesize' => { 0 => 0xa },
    'canonimagetype' => { 5 => 0x6, 18 => 0x815 },
    'canonimagewidth' => { 6 => 0x2 },
    'canonimagewidthasshot' => { 6 => 0x4 },
    'canonpictureinfo' => { 5 => 0x12, 18 => 0x1038 },
    'canonrawmakemodel' => { 18 => 0x80a },
    'canonshotinfo' => { 5 => 0x4, 18 => 0x102a },
    'caption-abstract' => { 34 => 0x78 },
    'captionwriter' => { 89 => 'CaptionWriter' },
    'captureconditionspar' => { 24 => 0xc352 },
    'capturedevicefid' => { 24 => 0xc357 },
    'captureresolution' => { 44 => 'resc' },
    'capturexresolution' => { 41 => 0x4 },
    'capturexresolutionunit' => { 41 => 0x9 },
    'captureyresolution' => { 41 => 0x0 },
    'captureyresolutionunit' => { 41 => 0x8 },
    'casioimagesize' => { 23 => 0x9 },
    'category' => { 34 => 0xf, 89 => 'Category' },
    'ccdisosensitivity' => { 23 => 0x3014 },
    'ccdsensitivity' => { 22 => 0x14, 63 => 0x6 },
    'celllength' => { 24 => 0x109 },
    'cellwidth' => { 24 => 0x108 },
    'certificate' => { 89 => 'Certificate' },
    'cfalayout' => { 24 => 0xc617 },
    'cfapattern' => { 24 => 0xa302, 89 => 'CFAPattern', 90 => 'CFAPattern' },
    'cfapattern2' => { 24 => 0x828e },
    'cfapatterncolumns' => { 89 => 'CFAPatternColumns' },
    'cfapatternrows' => { 89 => 'CFAPatternRows' },
    'cfapatternvalues' => { 89 => 'CFAPatternValues' },
    'cfaplanecolor' => { 24 => 0xc616 },
    'cfarepeatpatterndim' => { 24 => 0x828d },
    'chartarget' => { 31 => 'targ' },
    'chromablurradius' => { 24 => 0xc631 },
    'chromaticaberrationb' => { 89 => 'ChromaticAberrationB' },
    'chromaticaberrationr' => { 89 => 'ChromaticAberrationR' },
    'chromaticadaptation' => { 31 => 'chad' },
    'chromaticity' => { 31 => 'chrm' },
    'chromaticitychannel1' => { 28 => 0xc },
    'chromaticitychannel2' => { 28 => 0x14 },
    'chromaticitychannel3' => { 28 => 0x1c },
    'chromaticitychannel4' => { 28 => 0x24 },
    'chromaticitychannels' => { 28 => 0x8 },
    'chromaticitycolorant' => { 28 => 0xa },
    'city' => { 34 => 0x5a, 89 => 'City' },
    'class' => { 54 => 'class' },
    'classifystate' => { 34 => 0xe1 },
    'cleanfaxdata' => { 24 => 0x147 },
    'clippath' => { 24 => 0x157 },
    'clippingpathname' => { 80 => 0xbb7 },
    'cmmflags' => { 30 => 0x2c },
    'codedcharacterset' => { 35 => 0x5a },
    'codestreamheader' => { 44 => 'jpch' },
    'codestreamregistration' => { 44 => 'creg' },
    'codingmethods' => { 24 => 0x193 },
    'coloradjustment' => { 86 => 0x14 },
    'coloradjustmentmode' => { 85 => 0x210 },
    'colorant1coordinates' => { 29 => 0x2c },
    'colorant1name' => { 29 => 0xc },
    'colorant2coordinates' => { 29 => 0x52 },
    'colorant2name' => { 29 => 0x32 },
    'colorant3coordinates' => { 29 => 0x78 },
    'colorant3name' => { 29 => 0x58 },
    'colorantcount' => { 29 => 0x8 },
    'colorantorder' => { 31 => 'clro' },
    'coloranttable' => { 31 => 'clrt' },
    'colorbalance0100' => { 62 => 0x97 },
    'colorbalance0102' => { 62 => 0x97 },
    'colorbalance0103' => { 62 => 0x97 },
    'colorbalance1' => { 62 => 0xc },
    'colorbalanceblue' => { 55 => 0x1e },
    'colorbalancegreen' => { 55 => 0x1d },
    'colorbalancered' => { 55 => 0x1c },
    'colorbalanceunknown' => { 62 => 0x97 },
    'colorbitdepth' => { 17 => 0x5 },
    'colorbw' => { 17 => 0x6 },
    'colorcalibrationmatrix' => { 37 => 0x46 },
    'colorcharacterization' => { 24 => 0x84ed },
    'colorcontrol' => { 70 => 0x102b },
    'coloreffect' => { 77 => 0x28 },
    'colorfilter' => { 55 => 0x29 },
    'colorgroup' => { 44 => 'cgrp' },
    'colorhalftoninginfo' => { 80 => 0x3f5 },
    'colorhue' => { 62 => 0x8d },
    'colormap' => { 24 => 0x140 },
    'colormatrix' => { 2 => 0xa, 69 => 0x200, 70 => 0x1011 },
    'colormatrix1' => { 24 => 0xc621 },
    'colormatrix2' => { 24 => 0xc622 },
    'colormode' => { 23 => 0x3015, 46 => 0x66, 55 => 0x28, 56 => 0x101, 62 => 0x3, 63 => 0x4, 70 => 0x101 },
    'colornoisereduction' => { 89 => 'ColorNoiseReduction' },
    'colorpalette' => { 37 => 0x55 },
    'colorrepresentation' => { 37 => 0x3c },
    'colorresponseunit' => { 24 => 0x12c },
    'colors' => { 54 => 'colors' },
    'colorsamplersresource' => { 80 => 0x40e },
    'colorsequence' => { 24 => 0x84e1, 37 => 0x41 },
    'colorspace' => { 18 => 0x10b4, 24 => 0xa001, 54 => 'colorspace', 66 => 0x507, 86 => 0xb, 89 => 'ColorSpace' },
    'colorspacedata' => { 30 => 0x10 },
    'colorspecification' => { 44 => 'colr' },
    'colortable' => { 24 => 0x84e6 },
    'colortemperature' => { 1 => 0x9, 2 => 0x9, 5 => 0xae, 18 => 0x10ae },
    'colortone' => { 0 => 0x2a },
    'colortransferfuncs' => { 80 => 0x3f8 },
    'colortype' => { 72 => 0x9 },
    'comment' => { 76 => 'Comment', 91 => 'Comment' },
    'componentbitdepth' => { 17 => 0x4 },
    'componentdefinition' => { 44 => 'cdef' },
    'componentmapping' => { 44 => 'cmap' },
    'componentsconfiguration' => { 24 => 0x9101, 89 => 'ComponentsConfiguration' },
    'componentversion' => { 18 => 0x80c },
    'compositinglayerheader' => { 44 => 'jplh' },
    'composition' => { 44 => 'comp' },
    'compositionoptions' => { 44 => 'copt' },
    'compressedbitsperpixel' => { 24 => 0x9102, 89 => 'CompressedBitsPerPixel' },
    'compressedimagesize' => { 56 => 0x40, 70 => 0x40 },
    'compressedtext' => { 73 => 'zTXt' },
    'compression' => { 24 => 0x103, 43 => 0xb, 54 => 'compression', 65 => 0x103, 72 => 0xa, 89 => 'Compression' },
    'compressionfactor' => { 66 => 0x50d },
    'compressionratio' => { 70 => 0x1034 },
    'conditionalfec' => { 90 => 'ConditionalFEC' },
    'confirmedobjectsize' => { 39 => 0xa },
    'consecutivebadfaxlines' => { 24 => 0x148 },
    'contact' => { 34 => 0x76 },
    'contentlocationcode' => { 34 => 0x1a },
    'contentlocationname' => { 34 => 0x1b },
    'contiguouscodestream' => { 44 => 'jp2c' },
    'continuousdrive' => { 0 => 0x5 },
    'contrast' => { 0 => 0xd, 22 => 0xc, 23 => 0x20, 24 => [0xa408,0xfe54], 25 => 0x1004, 55 => 0x20, 70 => 0x1029, 77 => 0x2c, 78 => 0x20, 86 => 0xd, 89 => 'Contrast' },
    'contrastsetting' => { 66 => 0x505 },
    'contributor' => { 89 => 'Contributor' },
    'converter' => { 24 => 0xfe4d, 63 => 0xb },
    'copyright' => { 24 => 0x8298, 31 => 'cprt', 76 => 'Copyright', 89 => 'Copyright' },
    'copyrightflag' => { 80 => 0x40a },
    'copyrightnotice' => { 34 => 0x74 },
    'coringfilter' => { 70 => 0x102d },
    'country' => { 89 => 'Country' },
    'country-primarylocationcode' => { 34 => 0x64 },
    'country-primarylocationname' => { 34 => 0x65 },
    'countrycode' => { 89 => 'CountryCode' },
    'coverage' => { 89 => 'Coverage' },
    'crdinfo' => { 31 => 'crdi' },
    'createdate' => { 24 => 0x9004, 89 => 'CreateDate' },
    'creationdate' => { 89 => 'CreationDate' },
    'creationtime' => { 76 => 'Creation Time' },
    'creator' => { 89 => 'Creator' },
    'creatorcontactinfo' => { 89 => 'CreatorContactInfo' },
    'creatorcontactinfociadrcity' => { 89 => 'CreatorContactInfoCiAdrCity' },
    'creatorcontactinfociadrctry' => { 89 => 'CreatorContactInfoCiAdrCtry' },
    'creatorcontactinfociadrextadr' => { 89 => 'CreatorContactInfoCiAdrExtadr' },
    'creatorcontactinfociadrpcode' => { 89 => 'CreatorContactInfoCiAdrPcode' },
    'creatorcontactinfociadrregion' => { 89 => 'CreatorContactInfoCiAdrRegion' },
    'creatorcontactinfociemailwork' => { 89 => 'CreatorContactInfoCiEmailWork' },
    'creatorcontactinfocitelwork' => { 89 => 'CreatorContactInfoCiTelWork' },
    'creatorcontactinfociurlwork' => { 89 => 'CreatorContactInfoCiUrlWork' },
    'creatortool' => { 89 => 'CreatorTool' },
    'credit' => { 34 => 0x6e, 89 => 'Credit' },
    'cross-reference' => { 44 => 'cref' },
    'customrendered' => { 24 => 0xa401, 89 => 'CustomRendered' },
    'customsaturation' => { 66 => 0x503 },
    'datacompressionmethod' => { 37 => 0x6e },
    'datadump' => { 62 => 0x10, 70 => 0xf00, 77 => 0x21, 78 => 0x3fe, 85 => 0xf00 },
    'datadump2' => { 70 => 0xf01 },
    'datareference' => { 44 => 'dtbl' },
    'datatype' => { 24 => 0x80e4 },
    'date' => { 46 => 0x10, 49 => 0xc, 78 => 0x6, 89 => 'Date' },
    'datecreated' => { 34 => 0x37, 89 => 'DateCreated' },
    'datesent' => { 35 => 0x46 },
    'datetime' => { 89 => 'DateTime' },
    'datetimecreated' => { 90 => 'DateTimeCreated' },
    'datetimedigitized' => { 89 => 'DateTimeDigitized' },
    'datetimeoriginal' => { 21 => 0x0, 24 => 0x9003, 89 => 'DateTimeOriginal', 90 => 'DateTimeOriginal' },
    'datetimestamp' => { 46 => 0x64 },
    'dealeridnumber' => { 24 => 0xc356 },
    'decode' => { 24 => 0x1b1 },
    'decodertable' => { 18 => 0x1835 },
    'decposition' => { 55 => 0x32 },
    'defaultcroporigin' => { 24 => 0xc61f },
    'defaultcropsize' => { 24 => 0xc620 },
    'defaultimagecolor' => { 24 => 0x1b2 },
    'defaultscale' => { 24 => 0xc61e },
    'delay' => { 54 => 'delay' },
    'depth' => { 54 => 'depth' },
    'derivedfrom' => { 89 => 'DerivedFrom' },
    'derivedfromdocumentid' => { 89 => 'DerivedFromDocumentID' },
    'derivedfrominstanceid' => { 89 => 'DerivedFromInstanceID' },
    'derivedfrommanager' => { 89 => 'DerivedFromManager' },
    'derivedfrommanagervariant' => { 89 => 'DerivedFromManagerVariant' },
    'derivedfrommanageto' => { 89 => 'DerivedFromManageTo' },
    'derivedfrommanageui' => { 89 => 'DerivedFromManageUI' },
    'derivedfromrenditionclass' => { 89 => 'DerivedFromRenditionClass' },
    'derivedfromrenditionparams' => { 89 => 'DerivedFromRenditionParams' },
    'derivedfromversionid' => { 89 => 'DerivedFromVersionID' },
    'description' => { 76 => 'Description', 89 => 'Description' },
    'desiredreproductions' => { 44 => 'drep' },
    'destination' => { 35 => 0x5 },
    'destinationcity' => { 78 => 0x24 },
    'destinationcitycode' => { 78 => 0x1001 },
    'destinationdst' => { 78 => 0x26 },
    'deviceattributes' => { 30 => 0x38 },
    'devicemanufacturer' => { 30 => 0x30 },
    'devicemfgdesc' => { 31 => 'dmnd' },
    'devicemodel' => { 30 => 0x34 },
    'devicemodeldesc' => { 31 => 'dmdd' },
    'devicesettingdescription' => { 24 => 0xa40b, 89 => 'DeviceSettingDescription' },
    'devicesettingdescriptioncolumns' => { 89 => 'DeviceSettingDescriptionColumns' },
    'devicesettingdescriptionrows' => { 89 => 'DeviceSettingDescriptionRows' },
    'devicesettingdescriptionsettings' => { 89 => 'DeviceSettingDescriptionSettings' },
    'devicesettings' => { 31 => 'devs' },
    'digitalcreationdate' => { 34 => 0x3e },
    'digitalcreationtime' => { 34 => 0x3f },
    'digitaleffectsname' => { 47 => 0x1 },
    'digitaleffectstype' => { 47 => 0x2 },
    'digitaleffectsversion' => { 47 => 0x0 },
    'digitalsignature' => { 44 => 'chck' },
    'digitalzoom' => { 0 => 0xc, 22 => 0xa, 46 => 0x68, 51 => 0x22, 52 => 0x1e, 55 => 0xc, 62 => 0x86, 63 => 0xa, 70 => 0x204, 78 => 0x1e, 85 => 0x204 },
    'digitalzoomon' => { 85 => 0x21b },
    'digitalzoomratio' => { 24 => 0xa404, 89 => 'DigitalZoomRatio' },
    'directory' => { 91 => 'Directory' },
    'disclaimer' => { 76 => 'Disclaimer' },
    'displayinfo' => { 80 => 0x3ef },
    'displayresolution' => { 44 => 'resd' },
    'displayxresolution' => { 42 => 0x4 },
    'displayxresolutionunit' => { 42 => 0x9 },
    'displayyresolution' => { 42 => 0x0 },
    'displayyresolutionunit' => { 42 => 0x8 },
    'dispose' => { 54 => 'dispose' },
    'distance1' => { 46 => 0x28 },
    'distance2' => { 46 => 0x2c },
    'distance3' => { 46 => 0x30 },
    'distance4' => { 46 => 0x34 },
    'distortioncorrection' => { 66 => 0x50b },
    'dngbackwardversion' => { 24 => 0xc613 },
    'dngcameraserialnumber' => { 24 => 0xc62f },
    'dnglensinfo' => { 24 => 0xc630 },
    'dngprivatedata' => { 24 => 0xc634 },
    'dngversion' => { 24 => 0xc612 },
    'documenthistory' => { 34 => 0xe7 },
    'documentid' => { 89 => 'DocumentID' },
    'documentname' => { 24 => 0x10d },
    'documentnotes' => { 34 => 0xe6 },
    'dotrange' => { 24 => 0x150 },
    'drivemode' => { 55 => 0x6, 86 => 0x3, 90 => 'DriveMode' },
    'duotonehalftoninginfo' => { 80 => 0x3f6 },
    'duotoneimageinfo' => { 80 => 0x3fa },
    'duotonetransferfuncs' => { 80 => 0x3f9 },
    'easymode' => { 0 => 0xb },
    'editorialupdate' => { 34 => 0x8 },
    'editstatus' => { 34 => 0x7 },
    'edittagarray' => { 24 => 0xc366 },
    'effectivebw' => { 80 => 0x3fb },
    'effectivemaxaperture' => { 61 => 0x12 },
    'effectsvisible' => { 80 => 0x412 },
    'endpoints' => { 37 => 0x7d },
    'enhancement' => { 23 => 0x3016 },
    'envelopenumber' => { 24 => 0xc358, 35 => 0x28 },
    'envelopepriority' => { 35 => 0x3c },
    'enveloperecordversion' => { 35 => 0x0 },
    'epsonimageheight' => { 70 => 0x20c },
    'epsonimagewidth' => { 70 => 0x20b },
    'epsonsoftware' => { 70 => 0x20d },
    'epsoptions' => { 80 => 0x3fd },
    'equipment' => { 70 => 0x2010 },
    'equipmentversion' => { 67 => 0x0 },
    'error' => { 91 => 'Error' },
    'ettlii' => { 12 => 0xd },
    'excursiontolerance' => { 37 => 0x82 },
    'exif' => { 91 => 'EXIF' },
    'exifcamerainfo' => { 34 => 0xe8 },
    'exifimageheight' => { 89 => 'PixelYDimension' },
    'exifimagelength' => { 24 => 0xa003 },
    'exifimagewidth' => { 24 => 0xa002, 89 => 'PixelXDimension' },
    'exifinformation' => { 18 => 0x300b },
    'exifoffset' => { 24 => 0x8769 },
    'exiftoolversion' => { 91 => 'ExifToolVersion' },
    'exifversion' => { 24 => 0x9000, 89 => 'ExifVersion' },
    'expirationdate' => { 34 => 0x25 },
    'expirationtime' => { 34 => 0x26 },
    'exposure' => { 24 => 0xfe51, 89 => 'Exposure' },
    'exposurebracketvalue' => { 62 => 0x19 },
    'exposurecompensation' => { 8 => 0x6, 14 => 0x0, 24 => 0x9204, 46 => 0x24, 55 => 0xd, 78 => 0x16, 86 => 0xc, 89 => 'ExposureBiasValue' },
    'exposuredifference' => { 62 => 0xe },
    'exposureindex' => { 24 => [0x9215,0xa215], 89 => 'ExposureIndex' },
    'exposureinfo' => { 18 => 0x1818 },
    'exposurelevelincrements' => { 10 => 0x6, 11 => 0x6, 12 => 0x5, 13 => 0x4 },
    'exposuremode' => { 24 => 0xa402, 55 => 0x1, 66 => 0x200, 86 => 0x8, 89 => 'ExposureMode' },
    'exposureprogram' => { 24 => 0x8822, 89 => 'ExposureProgram' },
    'exposuretime' => { 8 => 0x16, 24 => 0x829a, 46 => 0x20, 49 => 0x38, 51 => 0x14, 52 => 0x10, 78 => 0x12, 89 => 'ExposureTime' },
    'exposurewarning' => { 25 => 0x1302 },
    'extender' => { 67 => 0x301 },
    'extenderfirmwareversion' => { 67 => 0x304 },
    'extenderserialnumber' => { 67 => 0x302 },
    'externalflash' => { 68 => 0x1201 },
    'extrasamples' => { 24 => 0x152 },
    'faxprofile' => { 24 => 0x192 },
    'faxrecvparams' => { 24 => 0x885c },
    'faxrecvtime' => { 24 => 0x885e },
    'faxsubaddress' => { 24 => 0x885d },
    'fileformat' => { 16 => 0x0, 35 => 0x14 },
    'filemodifydate' => { 91 => 'FileModifyDate' },
    'filename' => { 91 => 'FileName' },
    'filenumber' => { 3 => 0x1, 5 => 0x8, 18 => 0x1817 },
    'filenumbermemory' => { 55 => 0x1a },
    'filesize' => { 91 => 'FileSize' },
    'filesource' => { 24 => 0xa300, 89 => 'FileSource' },
    'filesystemversion' => { 62 => 0x1 },
    'filetype' => { 44 => 'ftyp', 91 => 'FileType' },
    'fileversion' => { 35 => 0x16 },
    'fillflashautoreduction' => { 10 => 0xe, 11 => 0xe, 13 => 0xa },
    'fillorder' => { 24 => 0x10a },
    'filmcategory' => { 24 => 0xc35a },
    'filmgencode' => { 24 => 0xc35b },
    'filmproductcode' => { 24 => 0xc350 },
    'filmsize' => { 24 => 0xc35d },
    'filter' => { 23 => 0x3017, 72 => 0xb },
    'finderdisplayduringexposure' => { 11 => 0x1 },
    'firmware' => { 86 => 0x17 },
    'firmwareversion' => { 70 => 0x207, 77 => 0x2 },
    'firmwareversion2' => { 67 => 0x100 },
    'fixtureidentifier' => { 34 => 0x16 },
    'flash' => { 24 => 0x9209, 52 => 0x22, 89 => 'Flash' },
    'flashactivity' => { 0 => 0x1c },
    'flashbias' => { 70 => 0x1023, 77 => 0x24 },
    'flashbits' => { 0 => 0x1d },
    'flashdevice' => { 70 => 0x1005 },
    'flashdistance' => { 23 => 0x2034 },
    'flashenergy' => { 24 => [0x920b,0xa20b], 89 => 'FlashEnergy' },
    'flashexposurebracketvalue' => { 62 => 0x18 },
    'flashexposurecomp' => { 8 => 0xf, 55 => 0x23, 62 => 0x12 },
    'flashexposurecompensation' => { 66 => 0x401 },
    'flashfired' => { 46 => 0x5d, 55 => 0x14, 89 => 'FlashFired' },
    'flashfiring' => { 12 => 0x6 },
    'flashfirmwareversion' => { 67 => 0x1004 },
    'flashfunction' => { 89 => 'FlashFunction' },
    'flashguidenumber' => { 15 => 0x0 },
    'flashinfo' => { 18 => 0x1813 },
    'flashintensity' => { 22 => 0x5 },
    'flashmode' => { 22 => 0x4, 46 => 0x5c, 51 => 0x27, 55 => 0x2, 62 => 0x87, 66 => 0x400, 70 => 0x1004, 78 => 0xc, 85 => 0x225, 89 => 'FlashMode' },
    'flashmodel' => { 67 => 0x1001 },
    'flashon' => { 90 => 'FlashOn' },
    'flashpixversion' => { 24 => 0xa000, 89 => 'FlashpixVersion' },
    'flashredeyemode' => { 89 => 'FlashRedEyeMode' },
    'flashreturn' => { 89 => 'FlashReturn' },
    'flashserialnumber' => { 67 => 0x1003 },
    'flashsetting' => { 62 => 0x8 },
    'flashstrength' => { 25 => 0x1011 },
    'flashsyncspeedav' => { 10 => 0x3, 12 => 0x2, 13 => 0x6 },
    'flashthreshold' => { 15 => 0x1 },
    'flashtype' => { 62 => 0x9, 67 => 0x1000, 90 => 'FlashType' },
    'flickerreduce' => { 85 => 0x218 },
    'fnumber' => { 8 => 0x15, 24 => 0x829d, 46 => 0x1e, 49 => 0x3c, 51 => 0x1c, 52 => 0x18, 78 => 0x13, 89 => 'FNumber' },
    'focallength' => { 4 => 0x1, 23 => 0x1d, 24 => 0x920a, 55 => 0x12, 61 => 0xa, 78 => 0x1d, 89 => 'FocalLength' },
    'focallength35efl' => { 90 => 'FocalLength35efl' },
    'focallengthin35mmformat' => { 24 => 0xa405, 89 => 'FocalLengthIn35mmFilm' },
    'focalplanediagonal' => { 67 => 0x103, 70 => 0x205 },
    'focalplaneresolutionunit' => { 24 => [0x9210,0xa210], 89 => 'FocalPlaneResolutionUnit' },
    'focalplanexresolution' => { 24 => [0x920e,0xa20e], 89 => 'FocalPlaneXResolution' },
    'focalplanexsize' => { 4 => 0x2 },
    'focalplaneyresolution' => { 24 => [0x920f,0xa20f], 89 => 'FocalPlaneYResolution' },
    'focalplaneysize' => { 4 => 0x3 },
    'focalunits' => { 0 => 0x19 },
    'focus' => { 63 => 0x8 },
    'focusarea' => { 55 => 0x31 },
    'focuscontinuous' => { 0 => 0x20 },
    'focusdistance' => { 55 => 0x13, 61 => 0x9, 68 => 0x305, 70 => 0x100c },
    'focusdistancelower' => { 8 => 0x14 },
    'focusdistanceupper' => { 8 => 0x13 },
    'focusinfo' => { 70 => 0x2050 },
    'focusinfoversion' => { 68 => 0x0 },
    'focusingscreen' => { 11 => 0x0 },
    'focusmode' => { 0 => 0x7, 22 => 0x3, 23 => [0x3003,0xd], 25 => 0x1021, 46 => 0x38, 55 => 0x30, 62 => 0x7, 66 => 0x301, 70 => 0x100b, 77 => 0x7, 78 => 0xd },
    'focusposition' => { 61 => 0x8, 78 => 0x10 },
    'focusprocess' => { 66 => 0x302 },
    'focussetting' => { 86 => 0x6 },
    'focustype' => { 0 => 0x12 },
    'focuswarning' => { 25 => 0x1301 },
    'foldername' => { 55 => 0x27 },
    'format' => { 89 => 'Format' },
    'fragmentlist' => { 44 => 'flst' },
    'fragmenttable' => { 44 => 'ftbl' },
    'framenumber' => { 24 => 0xc359, 78 => 0x29 },
    'free' => { 44 => 'free' },
    'freebytecounts' => { 24 => 0x121 },
    'freebytes' => { 18 => 0x1 },
    'freeoffsets' => { 24 => 0x120 },
    'fujiflashmode' => { 25 => 0x1010 },
    'gaincontrol' => { 24 => 0xa407, 89 => 'GainControl' },
    'gamma' => { 24 => 0xa500, 54 => 'gamma', 73 => 'gAMA' },
    'gammacompensatedvalue' => { 37 => 0x91 },
    'gamut' => { 31 => 'gamt' },
    'gdalmetadata' => { 24 => 0xa480 },
    'gdalnodata' => { 24 => 0xa481 },
    'geogangularunits' => { 27 => 0x806 },
    'geogangularunitsize' => { 27 => 0x807 },
    'geogazimuthunits' => { 27 => 0x80c },
    'geogcitation' => { 27 => 0x801 },
    'geogellipsoid' => { 27 => 0x808 },
    'geoggeodeticdatum' => { 27 => 0x802 },
    'geoginvflattening' => { 27 => 0x80b },
    'geoglinearunits' => { 27 => 0x804 },
    'geoglinearunitsize' => { 27 => 0x805 },
    'geogprimemeridian' => { 27 => 0x803 },
    'geogprimemeridianlong' => { 27 => 0x80d },
    'geographictype' => { 27 => 0x800 },
    'geogsemimajoraxis' => { 27 => 0x809 },
    'geogsemiminoraxis' => { 27 => 0x80a },
    'geotiffasciiparams' => { 24 => 0x87b1 },
    'geotiffdirectory' => { 24 => 0x87af },
    'geotiffdoubleparams' => { 24 => 0x87b0 },
    'geotiffversion' => { 27 => 0x1 },
    'globalaltitude' => { 80 => 0x419 },
    'globalangle' => { 80 => 0x40d },
    'globalparametersifd' => { 24 => 0x190 },
    'gpsaltitude' => { 26 => 0x6, 89 => 'GPSAltitude' },
    'gpsaltituderef' => { 26 => 0x5, 89 => 'GPSAltitudeRef' },
    'gpsareainformation' => { 26 => 0x1c, 89 => 'GPSAreaInformation' },
    'gpsdatestamp' => { 26 => 0x1d },
    'gpsdatetime' => { 90 => 'GPSDateTime' },
    'gpsdestbearing' => { 26 => 0x18, 89 => 'GPSDestBearing' },
    'gpsdestbearingref' => { 26 => 0x17, 89 => 'GPSDestBearingRef' },
    'gpsdestdistance' => { 26 => 0x1a, 89 => 'GPSDestDistance' },
    'gpsdestdistanceref' => { 26 => 0x19, 89 => 'GPSDestDistanceRef' },
    'gpsdestlatitude' => { 26 => 0x14, 89 => 'GPSDestLatitude' },
    'gpsdestlatituderef' => { 26 => 0x13 },
    'gpsdestlongitude' => { 26 => 0x16, 89 => 'GPSDestLongitude' },
    'gpsdestlongituderef' => { 26 => 0x15 },
    'gpsdifferential' => { 26 => 0x1e, 89 => 'GPSDifferential' },
    'gpsdop' => { 26 => 0xb },
    'gpsimgdirection' => { 26 => 0x11, 89 => 'GPSImgDirection' },
    'gpsimgdirectionref' => { 26 => 0x10, 89 => 'GPSImgDirectionRef' },
    'gpsinfo' => { 24 => 0x8825 },
    'gpslatitude' => { 26 => 0x2, 89 => 'GPSLatitude' },
    'gpslatituderef' => { 26 => 0x1 },
    'gpslongitude' => { 26 => 0x4, 89 => 'GPSLongitude' },
    'gpslongituderef' => { 26 => 0x3 },
    'gpsmapdatum' => { 26 => 0x12, 89 => 'GPSMapDatum' },
    'gpsmeasuremode' => { 26 => 0xa },
    'gpsprocessingmethod' => { 26 => 0x1b, 89 => 'GPSProcessingMethod' },
    'gpssatellites' => { 26 => 0x8, 89 => 'GPSSatellites' },
    'gpsspeed' => { 26 => 0xd, 89 => 'GPSSpeed' },
    'gpsspeedref' => { 26 => 0xc, 89 => 'GPSSpeedRef' },
    'gpsstatus' => { 26 => 0x9, 89 => 'GPSStatus' },
    'gpstimestamp' => { 26 => 0x7, 89 => 'GPSTimeStamp' },
    'gpstrack' => { 26 => 0xf, 89 => 'GPSTrack' },
    'gpstrackref' => { 26 => 0xe, 89 => 'GPSTrackRef' },
    'gpsversionid' => { 26 => 0x0, 89 => 'GPSVersionID' },
    'gradation' => { 66 => 0x50f },
    'graphicstechnologystandardoutput' => { 44 => 'gtso' },
    'grayresponsecurve' => { 24 => 0x123 },
    'grayresponseunit' => { 24 => 0x122 },
    'graytrc' => { 31 => 'kTRC' },
    'greengain' => { 84 => 'Gg' },
    'greenhue' => { 89 => 'GreenHue' },
    'greenmatrixcolumn' => { 31 => 'gXYZ' },
    'greenprimary' => { 54 => 'green-primary' },
    'greensaturation' => { 89 => 'GreenSaturation' },
    'greentrc' => { 31 => 'gTRC' },
    'greenx' => { 75 => 0x4 },
    'greeny' => { 75 => 0x5 },
    'gridguidesinfo' => { 80 => 0x408 },
    'gtcitation' => { 27 => 0x402 },
    'gtmodeltype' => { 27 => 0x400 },
    'gtrastertype' => { 27 => 0x401 },
    'halftonehints' => { 24 => 0x141 },
    'hcusage' => { 24 => 0x84ee },
    'headline' => { 34 => 0x69, 89 => 'Headline' },
    'highlight' => { 86 => 0xf },
    'history' => { 89 => 'History' },
    'historyaction' => { 89 => 'HistoryAction' },
    'historyinstanceid' => { 89 => 'HistoryInstanceID' },
    'historyparameters' => { 89 => 'HistoryParameters' },
    'historysoftwareagent' => { 89 => 'HistorySoftwareAgent' },
    'historywhen' => { 89 => 'HistoryWhen' },
    'hometowncity' => { 78 => 0x23 },
    'hometowncitycode' => { 78 => 0x1000 },
    'hometowndst' => { 78 => 0x25 },
    'hostcomputer' => { 24 => 0x13c },
    'hueadjustment' => { 62 => 0x92 },
    'icc_profile' => { 24 => 0x8773, 73 => 'iCCP', 80 => 0x40f },
    'icc_untagged' => { 80 => 0x411 },
    'iccprofile' => { 37 => 0x42 },
    'id' => { 54 => 'id' },
    'identifier' => { 89 => 'Identifier' },
    'idsbasevalue' => { 80 => 0x414 },
    'ifd0_offset' => { 64 => 0x1 },
    'imageadjustment' => { 62 => 0x80, 63 => 0x5 },
    'imageboundary' => { 62 => 0x16 },
    'imagecolorindicator' => { 24 => 0x84e7 },
    'imagecolorvalue' => { 24 => 0x84e9 },
    'imagedepth' => { 24 => 0x80e5 },
    'imagedescription' => { 18 => 0x2804, 24 => 0x10e, 89 => 'ImageDescription' },
    'imageformat' => { 18 => 0x1803 },
    'imageheader' => { 44 => 'ihdr', 73 => 'IHDR' },
    'imageheight' => { 17 => 0x1, 24 => 0x101, 43 => 0x0, 54 => 'rows', 72 => 0x4, 89 => 'ImageLength', 91 => 'ImageHeight' },
    'imagehistory' => { 24 => [0x9213,0xa213] },
    'imageid' => { 24 => 0x800d },
    'imageinfo' => { 18 => 0x1810 },
    'imagelayer' => { 24 => 0x87ac },
    'imagenumber' => { 24 => [0x9211,0xa211] },
    'imageoptimization' => { 62 => 0xa9 },
    'imageorientation' => { 34 => 0x83 },
    'imageprintstatus' => { 24 => 0xc46e },
    'imageprocessing' => { 70 => 0x2040 },
    'imageprocessingversion' => { 69 => 0x0 },
    'imageprops' => { 18 => 0x300a },
    'imagequality' => { 77 => 0x1 },
    'imagequality2' => { 66 => 0x603 },
    'imagerotated' => { 51 => 0x2a },
    'imagerotationstatus' => { 24 => 0xc363 },
    'imagesize' => { 90 => 'ImageSize' },
    'imagesourcedata' => { 24 => 0x935c },
    'imagesourceek' => { 24 => 0xc351 },
    'imagestabilization' => { 56 => 0x18 },
    'imagestabilizer' => { 77 => 0x1a },
    'imagetype' => { 34 => 0x82 },
    'imageuniqueid' => { 24 => 0xa420, 89 => 'ImageUniqueID' },
    'imagewidth' => { 17 => 0x0, 24 => 0x100, 43 => 0x4, 54 => 'columns', 72 => 0x0, 89 => 'ImageWidth', 91 => 'ImageWidth' },
    'indexed' => { 24 => 0x15a },
    'indexedcolourtablecount' => { 80 => 0x416 },
    'inknames' => { 24 => 0x14d },
    'inkset' => { 24 => 0x14c },
    'instructions' => { 89 => 'Instructions' },
    'instructionset' => { 44 => 'inst' },
    'intellectualgenre' => { 89 => 'IntellectualGenre' },
    'intellectualproperty' => { 44 => 'jp2i' },
    'interchangecolorspace' => { 37 => 0x40 },
    'intergraphflagregisters' => { 24 => 0x847f },
    'intergraphmatrix' => { 24 => 0x8480 },
    'intergraphpacketdata' => { 24 => 0x8474 },
    'interlace' => { 24 => 0x8829, 72 => 0xc },
    'internalflash' => { 55 => 0x2b, 68 => 0x1208 },
    'internationaltext' => { 73 => 'iTXt' },
    'interopindex' => { 24 => 0x1 },
    'interopoffset' => { 24 => 0xa005 },
    'interopversion' => { 24 => 0x2 },
    'intervallength' => { 55 => 0x10 },
    'intervalmode' => { 55 => 0x26 },
    'intervalnumber' => { 55 => 0x11 },
    'iptc-naa' => { 24 => 0x83bb },
    'iptc-naa2' => { 24 => 0x8568 },
    'iptcapplication' => { 36 => 0x2 },
    'iptcbitspersample' => { 37 => 0x56 },
    'iptcdata' => { 80 => 0x404 },
    'iptcenvelope' => { 36 => 0x1 },
    'iptcimageheight' => { 37 => 0x1e },
    'iptcimagerotation' => { 37 => 0x66 },
    'iptcimagewidth' => { 37 => 0x14 },
    'iptcnewsphoto' => { 36 => 0x3 },
    'iptcobjectdata' => { 36 => 0x8 },
    'iptcpicturenumber' => { 37 => 0xa },
    'iptcpixelheight' => { 37 => 0x32 },
    'iptcpixelwidth' => { 37 => 0x28 },
    'iptcpostobjectdata' => { 36 => 0x9 },
    'iptcpreobjectdata' => { 36 => 0x7 },
    'iso' => { 8 => 0x2, 23 => 0x14, 24 => 0x8827, 46 => 0x60, 49 => 0x4e, 51 => 0x1e, 52 => 0x1a, 62 => 0x2, 78 => 0x14, 89 => 'ISOSpeedRatings' },
    'isoexpansion' => { 12 => 0x7 },
    'isoselection' => { 62 => 0xf },
    'isosetting' => { 46 => 0x5e, 52 => 0x14, 55 => 0x24, 62 => 0x13 },
    'isospeedexpansion' => { 11 => 0x3 },
    'it8header' => { 24 => 0x84e2 },
    'iterations' => { 54 => 'iterations' },
    'ixusafpoint' => { 8 => 0xe },
    'jobid' => { 34 => 0xb8 },
    'jobref' => { 89 => 'JobRef' },
    'jobrefid' => { 89 => 'JobRefId' },
    'jobrefname' => { 89 => 'JobRefName' },
    'jobrefurl' => { 89 => 'JobRefUrl' },
    'jp2header' => { 44 => 'jp2h' },
    'jp2signature' => { 44 => ["jP\x1a\x1a",'jP  '] },
    'jpeg_quality' => { 80 => 0x406 },
    'jpegactables' => { 24 => 0x209 },
    'jpegdctables' => { 24 => 0x208 },
    'jpeglosslesspredictors' => { 24 => 0x205 },
    'jpegpointtransforms' => { 24 => 0x206 },
    'jpegproc' => { 24 => 0x200 },
    'jpegqtables' => { 24 => 0x207 },
    'jpegrestartinterval' => { 24 => 0x203 },
    'jpegtables' => { 24 => 0x15b },
    'jpgfromraw' => { 18 => 0x2007, 90 => 'JpgFromRaw' },
    'jpgfromrawlength' => { 24 => 0x202 },
    'jpgfromrawstart' => { 24 => 0x201 },
    'jumptoxpep' => { 80 => 0x41c },
    'keywords' => { 34 => 0x19, 89 => 'Keywords' },
    'kodakbordersifd' => { 24 => 0xc36f },
    'kodakeffectsifd' => { 24 => 0xc36e },
    'kodakimageheight' => { 46 => 0xe, 48 => 0x70 },
    'kodakimagewidth' => { 46 => 0xc, 48 => 0x6c },
    'kodakmaker' => { 48 => 0x8 },
    'kodakmodel' => { 46 => 0x0, 48 => 0x28 },
    'label' => { 44 => 'lbl ', 54 => 'label' },
    'language' => { 89 => 'Language' },
    'languageidentifier' => { 34 => 0x87 },
    'lastfilenumber' => { 55 => 0x1b },
    'lasturl' => { 89 => 'LastURL' },
    'layersgroupinfo' => { 80 => 0x402 },
    'layerstateinfo' => { 80 => 0x400 },
    'lcdpanels' => { 11 => 0x8 },
    'lens' => { 24 => 0xfdea, 62 => 0x84, 67 => 0x201, 86 => 0xa, 89 => 'Lens', 90 => 'Lens' },
    'lens35efl' => { 90 => 'Lens35efl' },
    'lensafstopbutton' => { 10 => 0x11, 11 => 0x13, 12 => 0x10, 13 => 0x9 },
    'lensdata0100' => { 62 => 0x98 },
    'lensdata0101' => { 62 => 0x98 },
    'lensdata0201' => { 62 => 0x98 },
    'lensdataunknown' => { 62 => 0x98 },
    'lensdataversion' => { 60 => 0x0, 61 => 0x0 },
    'lensfirmwareversion' => { 67 => 0x204 },
    'lensfstops' => { 60 => 0x7, 61 => 0xc, 62 => 0x8b },
    'lensid' => { 60 => 0x6, 61 => 0xb },
    'lensserialnumber' => { 67 => 0x202 },
    'lensspec' => { 90 => 'LensSpec' },
    'lenstype' => { 0 => 0x16, 62 => 0x83, 78 => 0x3f },
    'lightsource' => { 24 => 0x9208, 62 => 0x90, 89 => 'LightSource' },
    'lightsourcespecial' => { 85 => 0x21d },
    'linearizationtable' => { 24 => 0xc618 },
    'linearresponselimit' => { 24 => 0xc62e },
    'localcaption' => { 34 => 0x79 },
    'localizedcameramodel' => { 24 => 0xc615 },
    'location' => { 89 => 'Location' },
    'longexposurenoisereduction' => { 12 => 0x1, 13 => 0x1 },
    'longfocal' => { 0 => 0x17 },
    'lookuptable' => { 37 => 0x50 },
    'luminance' => { 31 => 'lumi' },
    'luminancesmoothing' => { 89 => 'LuminanceSmoothing' },
    'macintoshprintinfo' => { 80 => 0x3e9 },
    'macro' => { 25 => 0x1020, 51 => 0x2b, 70 => 0x202, 85 => 0x202 },
    'macrofocus' => { 70 => 0x100e },
    'macromode' => { 0 => 0x1, 55 => 0xb, 66 => 0x300, 77 => 0x1c },
    'magnification' => { 24 => 0xc367 },
    'make' => { 19 => 0x0, 24 => 0x10f, 89 => 'Make' },
    'makeandmodel' => { 31 => 'mmod' },
    'makernote' => { 89 => 'MakerNote' },
    'makernotecanon' => { 24 => 0x927c },
    'makernotecasio' => { 24 => 0x927c },
    'makernotecasio2' => { 24 => 0x927c },
    'makernotecasioex-z3' => { 24 => 0x927c },
    'makernotefujifilm' => { 24 => 0x927c },
    'makernotekodak1a' => { 24 => 0x927c },
    'makernotekodak1b' => { 24 => 0x927c },
    'makernotekodak2' => { 24 => 0x927c },
    'makernotekodak3' => { 24 => 0x927c },
    'makernotekodak4' => { 24 => 0x927c },
    'makernotekodak5' => { 24 => 0x927c },
    'makernotekodak6a' => { 24 => 0x927c },
    'makernotekodak6b' => { 24 => 0x927c },
    'makernotekodakunknown' => { 24 => 0x927c },
    'makernotekyocera' => { 24 => 0x927c },
    'makernoteleica' => { 24 => 0x927c },
    'makernoteminolta' => { 24 => 0x927c },
    'makernotenikon' => { 24 => 0x927c },
    'makernotenikon2' => { 24 => 0x927c },
    'makernotenikon3' => { 24 => 0x927c },
    'makernoteoffset' => { 85 => 0xff },
    'makernoteolympus' => { 24 => 0x927c },
    'makernotepanasonic' => { 24 => 0x927c },
    'makernotepentax' => { 24 => 0x927c },
    'makernotericoh' => { 24 => 0x927c },
    'makernotericohtext' => { 24 => 0x927c },
    'makernotesafety' => { 24 => 0xc635 },
    'makernotesanyo' => { 24 => 0x927c },
    'makernotesigma' => { 24 => 0x927c },
    'makernotesony' => { 24 => 0x927c },
    'makernotetype' => { 82 => 0x1 },
    'makernoteunknown' => { 24 => 0x927c },
    'makernoteversion' => { 56 => 0x0, 70 => 0x0, 82 => 0x2 },
    'managedfrom' => { 89 => 'ManagedFrom' },
    'managedfromdocumentid' => { 89 => 'ManagedFromDocumentID' },
    'managedfrominstanceid' => { 89 => 'ManagedFromInstanceID' },
    'managedfrommanager' => { 89 => 'ManagedFromManager' },
    'managedfrommanagervariant' => { 89 => 'ManagedFromManagerVariant' },
    'managedfrommanageto' => { 89 => 'ManagedFromManageTo' },
    'managedfrommanageui' => { 89 => 'ManagedFromManageUI' },
    'managedfromrenditionclass' => { 89 => 'ManagedFromRenditionClass' },
    'managedfromrenditionparams' => { 89 => 'ManagedFromRenditionParams' },
    'managedfromversionid' => { 89 => 'ManagedFromVersionID' },
    'manager' => { 89 => 'Manager' },
    'managervariant' => { 89 => 'ManagerVariant' },
    'manageto' => { 89 => 'ManageTo' },
    'manageui' => { 89 => 'ManageUI' },
    'manualfocusdistance' => { 62 => 0x85, 85 => 0x223 },
    'manualtv' => { 11 => 0x5 },
    'marked' => { 89 => 'Marked' },
    'masterdocumentid' => { 34 => 0xb9 },
    'mattcolor' => { 54 => 'matt-color' },
    'matte' => { 54 => 'matte' },
    'matteing' => { 24 => 0x80e3 },
    'maxaperture' => { 55 => 0x17 },
    'maxapertureatmaxfocal' => { 60 => 0xb, 61 => 0x10, 67 => 0x206 },
    'maxapertureatminfocal' => { 60 => 0xa, 61 => 0xf },
    'maxaperturevalue' => { 24 => 0x9205, 89 => 'MaxApertureValue' },
    'maxfocallength' => { 60 => 0x9, 61 => 0xe, 67 => 0x208 },
    'maximumdensityrange' => { 37 => 0x8c },
    'maximumobjectsize' => { 40 => 0x5f },
    'maxsamplevalue' => { 24 => 0x119 },
    'maxsubfilesize' => { 40 => 0x14 },
    'mcuversion' => { 60 => 0xc, 61 => 0x11 },
    'measuredev' => { 18 => 0x1814 },
    'measuredinfo' => { 18 => 0x3003 },
    'measurement' => { 31 => 'meas' },
    'measurementbacking' => { 32 => 0xc },
    'measurementflare' => { 32 => 0x1c },
    'measurementgeometry' => { 32 => 0x18 },
    'measurementilluminant' => { 32 => 0x20 },
    'measurementobserver' => { 32 => 0x8 },
    'mediablackpoint' => { 31 => 'bkpt' },
    'mediadata' => { 44 => 'mdat' },
    'mediawhitepoint' => { 31 => 'wtpt' },
    'menubuttondisplayposition' => { 10 => 0xb, 12 => 0xa },
    'menubuttonreturn' => { 13 => 0xb },
    'metadatadate' => { 89 => 'MetadataDate' },
    'metadatanumber' => { 24 => 0xc365 },
    'meteringmode' => { 0 => 0x11, 24 => 0x9207, 46 => 0x1c, 55 => 0x7, 66 => 0x202, 78 => 0x17, 86 => 0x9, 89 => 'MeteringMode' },
    'minfocallength' => { 60 => 0x8, 61 => 0xd, 67 => 0x207 },
    'minoltaaperture' => { 55 => 0xa },
    'minoltacamerasettings' => { 56 => 0x3, 70 => 0x3 },
    'minoltacamerasettings2' => { 56 => 0xf00 },
    'minoltacamerasettingsold' => { 56 => 0x1, 70 => 0x1 },
    'minoltadate' => { 55 => 0x15 },
    'minoltaimagesize' => { 55 => 0x4 },
    'minoltaiso' => { 55 => 0x8 },
    'minoltamodel' => { 55 => 0x25 },
    'minoltaquality' => { 55 => 0x5, 56 => [0x102,0x103], 70 => [0x102,0x103] },
    'minoltashutterspeed' => { 55 => 0x9 },
    'minoltatime' => { 55 => 0x16 },
    'minsamplevalue' => { 24 => 0x118 },
    'mirrorlockup' => { 10 => 0xc, 11 => 0xc, 12 => 0xb, 13 => 0x3 },
    'moddate' => { 89 => 'ModDate' },
    'model' => { 19 => 0x6, 24 => 0x110, 89 => 'Model' },
    'model2' => { 24 => 0x827d },
    'modelandversion' => { 24 => 0xc35c },
    'modeltiepoint' => { 24 => 0x8482 },
    'modeltransform' => { 24 => 0x85d8 },
    'modenumber' => { 24 => 0x195 },
    'modifiedsaturation' => { 66 => 0x504 },
    'modifydate' => { 24 => 0x132, 73 => 'tIME', 89 => 'ModifyDate' },
    'moirefilter' => { 24 => 0xfe58 },
    'montage' => { 54 => 'montage' },
    'mpeg7binary' => { 44 => 'mp7b' },
    'namedcolor' => { 31 => 'ncol' },
    'namedcolor2' => { 31 => 'ncl2' },
    'nativedisplayinfo' => { 31 => 'ndin' },
    'nativeresolutionunit' => { 24 => 0xc37a },
    'nativexresolution' => { 24 => 0xc36c },
    'nativeyresolution' => { 24 => 0xc36d },
    'nefcurve1' => { 62 => 0x8c },
    'nefcurve2' => { 62 => 0x96 },
    'nefthumbnailsize' => { 62 => 0x99 },
    'newsphotoversion' => { 37 => 0x0 },
    'nickname' => { 89 => 'Nickname' },
    'nikoncaptureoffsets' => { 62 => 0xe0e },
    'nikonpreview' => { 62 => 0x11 },
    'noise' => { 24 => [0x920d,0xa20d] },
    'noisefilter2' => { 69 => 0x1010 },
    'noisereduction' => { 62 => 0x95, 66 => 0x50a, 77 => 0x2d },
    'nullrecord' => { 18 => 0x0 },
    'numberlist' => { 44 => 'nlst' },
    'numberofcomponents' => { 43 => 0x8 },
    'numberofinks' => { 24 => 0x14e },
    'numindexentries' => { 37 => 0x54 },
    'objectattributereference' => { 34 => 0x4 },
    'objectcycle' => { 34 => 0x4b },
    'objectdistance' => { 22 => 0x6, 23 => 0x2022 },
    'objectname' => { 34 => 0x5 },
    'objectpreviewdata' => { 34 => 0xca },
    'objectpreviewfileformat' => { 34 => 0xc8 },
    'objectpreviewfileversion' => { 34 => 0xc9 },
    'objectsizeannounced' => { 40 => 0x5a },
    'objecttypereference' => { 34 => 0x3 },
    'obsoletephotoshoptag1' => { 80 => 0x3fc },
    'obsoletephotoshoptag2' => { 80 => 0x3ff },
    'obsoletephotoshoptag3' => { 80 => 0x403 },
    'oceapplicationselector' => { 24 => 0xc428 },
    'oceidnumber' => { 24 => 0xc429 },
    'oceimagelogic' => { 24 => 0xc42a },
    'ocescanjobdesc' => { 24 => 0xc427 },
    'oecfcolumns' => { 89 => 'OECFColumns' },
    'oecfnames' => { 89 => 'OECFNames' },
    'oecfrows' => { 89 => 'OECFRows' },
    'oecfvalues' => { 89 => 'OECFValues' },
    'oldsubfiletype' => { 24 => 0xff },
    'olympusimageheight' => { 70 => 0x102f },
    'olympusimageheight2' => { 69 => 0x615 },
    'olympusimagewidth' => { 70 => 0x102e },
    'olympusimagewidth2' => { 69 => 0x614 },
    'onetouchwb' => { 70 => 0x302 },
    'opacity' => { 44 => 'opct' },
    'opiproxy' => { 24 => 0x15f },
    'opticalzoom' => { 51 => 0x20, 52 => 0x1c },
    'opticalzoomon' => { 85 => 0x219 },
    'opto-electricconvfactor' => { 24 => 0x8828, 89 => 'OECF' },
    'orientation' => { 24 => 0x112, 89 => 'Orientation' },
    'originalfilename' => { 18 => 0x816, 50 => 0x20 },
    'originaltransmissionreference' => { 34 => 0x67 },
    'originatingprogram' => { 34 => 0x41 },
    'otherimagelength' => { 24 => 0x202 },
    'otherimagestart' => { 24 => 0x201 },
    'outputresponse' => { 31 => 'resp' },
    'owner' => { 89 => 'Owner' },
    'ownerid' => { 34 => 0xbc },
    'ownername' => { 5 => 0x9, 18 => 0x810, 24 => 0xfde8 },
    'packets' => { 54 => 'packets' },
    'page' => { 54 => 'page' },
    'pagename' => { 24 => 0x11d },
    'pagenumber' => { 24 => 0x129 },
    'palette' => { 44 => 'pclr' },
    'panoramamode' => { 46 => 0x3c },
    'pcscitation' => { 27 => 0xc01 },
    'pdfversion' => { 89 => 'PDFVersion' },
    'pentaximagesize' => { 78 => 0x9 },
    'pentaxmode' => { 78 => 0x1 },
    'photometricinterpretation' => { 24 => 0x106, 89 => 'PhotometricInterpretation' },
    'photoshop2colortable' => { 80 => 0x3eb },
    'photoshop2info' => { 80 => 0x3e8 },
    'photoshopformat' => { 79 => 0x1 },
    'photoshopquality' => { 79 => 0x0 },
    'photoshopsettings' => { 24 => 0x8649 },
    'photoshopthumbnail' => { 80 => 0x40c },
    'physicalpixel' => { 73 => 'pHYs' },
    'pictinfo' => { 85 => 0x208 },
    'pictureinfo' => { 70 => 0x208 },
    'picturemode' => { 25 => 0x1031, 78 => 0xb },
    'pixelaspectratio' => { 17 => 0x2 },
    'pixelintensityrange' => { 24 => 0x84eb },
    'pixelscale' => { 24 => 0x830e },
    'pixelsperunitx' => { 74 => 0x0 },
    'pixelsperunity' => { 74 => 0x4 },
    'pixelunits' => { 74 => 0x8 },
    'planarconfiguration' => { 24 => 0x11c, 89 => 'PlanarConfiguration' },
    'postscript2crd0' => { 31 => 'psd0' },
    'postscript2crd1' => { 31 => 'psd1' },
    'postscript2crd2' => { 31 => 'psd2' },
    'postscript2csa' => { 31 => 'ps2s' },
    'precaptureframes' => { 70 => 0x300 },
    'predictor' => { 24 => 0x13d },
    'preview0' => { 31 => 'pre0' },
    'preview1' => { 31 => 'pre1' },
    'preview2' => { 31 => 'pre2' },
    'previewfocalplanexresolution' => { 7 => 0x6 },
    'previewfocalplaneyresolution' => { 7 => 0x8 },
    'previewifd_offset' => { 64 => 0x2 },
    'previewimage' => { 23 => 0x2000, 24 => 0x927c, 90 => 'PreviewImage' },
    'previewimagedata' => { 56 => 0x81, 70 => 0x81 },
    'previewimageheight' => { 7 => 0x4 },
    'previewimageinfo' => { 5 => 0xb6 },
    'previewimagelength' => { 7 => 0x2, 23 => 0x3, 24 => [0x117,0x202], 56 => 0x89, 65 => 0x202, 66 => 0x102, 70 => [0x89,0x1037], 78 => 0x3 },
    'previewimagesize' => { 23 => 0x2, 78 => 0x2, 90 => 'PreviewImageSize' },
    'previewimagestart' => { 7 => 0x5, 23 => 0x4, 24 => [0x111,0x201], 56 => 0x88, 65 => 0x201, 66 => 0x101, 70 => [0x88,0x1036], 78 => 0x4 },
    'previewimagevalid' => { 66 => 0x100, 70 => 0x1035 },
    'previewimagewidth' => { 7 => 0x3 },
    'primarychromaticities' => { 24 => 0x13f, 73 => 'cHRM', 89 => 'PrimaryChromaticities' },
    'primaryplatform' => { 30 => 0x28 },
    'printflags' => { 80 => 0x3f3 },
    'printflagsinfo' => { 80 => 0x2710 },
    'printim' => { 23 => 0xe00, 24 => 0xc4a5, 56 => 0xe00, 62 => 0xe00, 70 => 0xe00, 77 => 0xe00, 78 => 0xe00, 82 => 0xe00, 85 => 0xe00, 87 => 0xe00, 88 => 0xe00 },
    'printquality' => { 24 => 0xc46c },
    'processgeotiff' => { 90 => 'ProcessGeoTiff' },
    'producer' => { 89 => 'Producer' },
    'productid' => { 35 => 0x32 },
    'profile' => { 44 => 'prfl' },
    'profileapp1' => { 54 => 'profile-APP1' },
    'profileclass' => { 30 => 0xc },
    'profilecmmtype' => { 30 => 0x4 },
    'profileconnectionspace' => { 30 => [0x14,0x44] },
    'profilecreator' => { 30 => 0x50 },
    'profiledatetime' => { 30 => 0x18 },
    'profiledescription' => { 31 => 'desc' },
    'profiledescriptionml' => { 31 => 'dscm' },
    'profilefilesignature' => { 30 => 0x24 },
    'profileheader' => { 31 => 'Header' },
    'profileicc' => { 54 => 'profile-icc' },
    'profileid' => { 30 => 0x54 },
    'profileiptc' => { 54 => 'profile-iptc' },
    'profilesequencedesc' => { 31 => 'pseq' },
    'profiletype' => { 24 => 0x191 },
    'profileversion' => { 30 => 0x8 },
    'programversion' => { 34 => 0x46 },
    'progressivescans' => { 79 => 0x2 },
    'projazimuthangle' => { 27 => 0xc16 },
    'projcentereasting' => { 27 => 0xc12 },
    'projcenterlat' => { 27 => 0xc11 },
    'projcenterlong' => { 27 => 0xc10 },
    'projcenternorthing' => { 27 => 0xc13 },
    'projcoordtrans' => { 27 => 0xc03 },
    'projectedcstype' => { 27 => 0xc00 },
    'projection' => { 27 => 0xc02 },
    'projfalseeasting' => { 27 => 0xc0a },
    'projfalsenorthing' => { 27 => 0xc0b },
    'projfalseorigineasting' => { 27 => 0xc0e },
    'projfalseoriginlat' => { 27 => 0xc0d },
    'projfalseoriginlong' => { 27 => 0xc0c },
    'projfalseoriginnorthing' => { 27 => 0xc0f },
    'projlinearunits' => { 27 => 0xc04 },
    'projlinearunitsize' => { 27 => 0xc05 },
    'projnatoriginlat' => { 27 => 0xc09 },
    'projnatoriginlong' => { 27 => 0xc08 },
    'projrectifiedgridangle' => { 27 => 0xc18 },
    'projscaleatcenter' => { 27 => 0xc15 },
    'projscaleatnatorigin' => { 27 => 0xc14 },
    'projstdparallel1' => { 27 => 0xc06 },
    'projstdparallel2' => { 27 => 0xc07 },
    'projstraightvertpolelong' => { 27 => 0xc17 },
    'province-state' => { 34 => 0x5f },
    'ps2crdvmsize' => { 31 => 'psvm' },
    'ps2renteringintent' => { 31 => 'ps2i' },
    'pstringcaption' => { 80 => 0x3f0 },
    'publisher' => { 89 => 'Publisher' },
    'quality' => { 0 => 0x3, 22 => 0x2, 23 => 0x3002, 25 => 0x1000, 46 => 0x9, 62 => 0x4, 63 => 0x3, 70 => 0x201, 78 => 0x8, 86 => 0x16 },
    'qualitymode' => { 23 => 0x8 },
    'quantizationmethod' => { 37 => 0x78 },
    'quickmaskinfo' => { 80 => 0x3fe },
    'quickshot' => { 85 => 0x213 },
    'rasterizedcaption' => { 34 => 0x7d },
    'rasterpadding' => { 24 => 0x84e3 },
    'rawandjpgrecording' => { 10 => 0x8 },
    'rawdata' => { 18 => 0x2005 },
    'rawdevcolorspace' => { 71 => 0x108 },
    'rawdevcontrastvalue' => { 71 => 0x106 },
    'rawdeveditstatus' => { 71 => 0x10b },
    'rawdevelopment' => { 70 => 0x2030 },
    'rawdevengine' => { 71 => 0x109 },
    'rawdevexposurebiasvalue' => { 71 => 0x100 },
    'rawdevgraypoint' => { 71 => 0x103 },
    'rawdevmemorycoloremphasis' => { 71 => 0x105 },
    'rawdevnoisereduction' => { 71 => 0x10a },
    'rawdevsaturationemphasis' => { 71 => 0x104 },
    'rawdevsettings' => { 71 => 0x10c },
    'rawdevsharpnessvalue' => { 71 => 0x107 },
    'rawdevversion' => { 71 => 0x0 },
    'rawdevwbfineadjustment' => { 71 => 0x102 },
    'rawdevwhitebalancevalue' => { 71 => 0x101 },
    'rawfile' => { 24 => 0xfe4c },
    'rawfilename' => { 89 => 'RawFileName' },
    'rawimagemode' => { 80 => 0x405 },
    'rawimagesize' => { 78 => 0x39 },
    'rawprofiletypeapp1' => { 76 => 'Raw profile type APP1' },
    'rawprofiletypeexif' => { 76 => 'Raw profile type exif' },
    'rawprofiletypeicc' => { 76 => 'Raw profile type icc' },
    'rawprofiletypeiptc' => { 76 => 'Raw profile type iptc' },
    'rawprofiletypexmp' => { 76 => 'Raw profile type xmp' },
    'readerrequirements' => { 44 => 'rreq' },
    'recordid' => { 18 => 0x1804 },
    'recordingmode' => { 22 => 0x1 },
    'recordmode' => { 23 => 0x3000 },
    'recordshutterrelease' => { 85 => 0x217 },
    'redbalance' => { 57 => 0x0, 58 => 0x0, 59 => 0x0, 70 => 0x1017, 78 => 0x1c },
    'redbalanceauto' => { 9 => 0x0 },
    'redbalanceb&w' => { 9 => 0xe },
    'redbalancecloudy' => { 9 => 0x4 },
    'redbalancecustom' => { 9 => 0xc },
    'redbalancedaylight' => { 9 => 0x2 },
    'redbalanceflash' => { 9 => 0xa },
    'redbalancefluorescent' => { 9 => 0x8 },
    'redbalanceshade' => { 9 => 0x10 },
    'redbalancetungsten' => { 9 => 0x6 },
    'redbluebias' => { 69 => 0x100 },
    'redeyereduction' => { 90 => 'RedEyeReduction' },
    'redgain' => { 84 => 'Rg' },
    'redhue' => { 89 => 'RedHue' },
    'redmatrixcolumn' => { 31 => 'rXYZ' },
    'redprimary' => { 54 => 'red-primary' },
    'redsaturation' => { 89 => 'RedSaturation' },
    'redtrc' => { 31 => 'rTRC' },
    'reductionmatrix1' => { 24 => 0xc625 },
    'reductionmatrix2' => { 24 => 0xc626 },
    'redx' => { 75 => 0x2 },
    'redy' => { 75 => 0x3 },
    'referenceblackwhite' => { 24 => 0x214, 89 => 'ReferenceBlackWhite' },
    'referencedate' => { 34 => 0x2f },
    'referencenumber' => { 34 => 0x32 },
    'referenceservice' => { 34 => 0x2d },
    'relatedimagefileformat' => { 24 => 0x1000 },
    'relatedimagelength' => { 24 => 0x1002 },
    'relatedimagewidth' => { 24 => 0x1001 },
    'relatedsoundfile' => { 24 => 0xa004, 89 => 'RelatedSoundFile' },
    'relation' => { 89 => 'Relation' },
    'releasedate' => { 34 => 0x1e },
    'releasesetting' => { 18 => 0x1016 },
    'releasetime' => { 34 => 0x23 },
    'renderingintent' => { 30 => 0x40, 54 => 'rendering-intent' },
    'renditionclass' => { 89 => 'RenditionClass' },
    'renditionof' => { 89 => 'RenditionOf' },
    'renditionofdocumentid' => { 89 => 'RenditionOfDocumentID' },
    'renditionofinstanceid' => { 89 => 'RenditionOfInstanceID' },
    'renditionofmanager' => { 89 => 'RenditionOfManager' },
    'renditionofmanagervariant' => { 89 => 'RenditionOfManagerVariant' },
    'renditionofmanageto' => { 89 => 'RenditionOfManageTo' },
    'renditionofmanageui' => { 89 => 'RenditionOfManageUI' },
    'renditionofrenditionclass' => { 89 => 'RenditionOfRenditionClass' },
    'renditionofrenditionparams' => { 89 => 'RenditionOfRenditionParams' },
    'renditionofversionid' => { 89 => 'RenditionOfVersionID' },
    'renditionparams' => { 89 => 'RenditionParams' },
    'resaved' => { 85 => 0x21e },
    'resolution' => { 44 => 'res ', 54 => 'resolution' },
    'resolutioninfo' => { 80 => 0x3ed },
    'resolutionmode' => { 86 => 0x4 },
    'resolutionunit' => { 24 => 0x128, 65 => 0x128, 89 => 'ResolutionUnit' },
    'revision' => { 84 => ['Rev','Rv'] },
    'ricohdatetime1' => { 83 => 0x4 },
    'ricohdatetime2' => { 83 => 0x5 },
    'ricohrr1subdir' => { 82 => 0x2001 },
    'ricohsubdir' => { 82 => 0x2001 },
    'rights' => { 89 => 'Rights' },
    'roidescription' => { 44 => 'roid' },
    'rollguidelements' => { 24 => 0xc364 },
    'romoperationmode' => { 18 => 0x80d },
    'rotation' => { 17 => 0x3 },
    'rowsperstrip' => { 24 => 0x116 },
    'safetyshiftinavortv' => { 10 => 0x10, 11 => 0x10, 12 => 0xf },
    'sampleformat' => { 24 => 0x153 },
    'samplesperpixel' => { 24 => 0x115, 89 => 'SamplesPerPixel' },
    'samplestructure' => { 37 => 0x5a },
    'sanyoquality' => { 85 => 0x201 },
    'sanyothumbnail' => { 85 => 0x100 },
    'saturation' => { 0 => 0xe, 22 => 0xd, 23 => 0x1f, 24 => [0xa409,0xfe55], 25 => 0x1003, 55 => 0x1f, 62 => [0x94,0xaa], 78 => 0x1f, 86 => 0x10, 89 => 'Saturation' },
    'saveid' => { 89 => 'SaveID' },
    'sba_rgbshifts' => { 24 => 0xc35e },
    'sbaexposurerecord' => { 24 => 0xc361 },
    'sbainputimagebitdepth' => { 24 => 0xc360 },
    'sbainputimagecolorspace' => { 24 => 0xc35f },
    'scalefactor35efl' => { 90 => 'ScaleFactor35efl' },
    'scanningdirection' => { 37 => 0x64 },
    'scene' => { 54 => 'scene', 89 => 'Scene' },
    'scenecapturetype' => { 24 => 0xa406, 89 => 'SceneCaptureType' },
    'scenemode' => { 62 => 0x8f, 66 => 0x509 },
    'sceneselect' => { 85 => 0x21f },
    'scenetype' => { 24 => 0xa301, 89 => 'SceneType' },
    'screening' => { 31 => 'scrn' },
    'screeningdesc' => { 31 => 'scrd' },
    'securityclassification' => { 24 => [0x9212,0xa212] },
    'self-timer' => { 0 => 0x2 },
    'self-timer2' => { 8 => 0x1d },
    'selftimer' => { 23 => 0x3001, 85 => 0x214 },
    'selftimermode' => { 24 => 0x882b },
    'selftimertime' => { 18 => 0x1806 },
    'sensingmethod' => { 24 => [0x9217,0xa217], 89 => 'SensingMethod' },
    'sensorbottomborder' => { 20 => 0x8 },
    'sensorcleaning' => { 13 => 0xd },
    'sensorheight' => { 20 => 0x2 },
    'sensorinfo' => { 18 => 0x1031 },
    'sensorleftborder' => { 20 => 0x5 },
    'sensorpixelsize' => { 62 => 0x9a },
    'sensorrightborder' => { 20 => 0x7 },
    'sensortopborder' => { 20 => 0x6 },
    'sensorwidth' => { 20 => 0x1 },
    'sequence' => { 66 => 0x600 },
    'sequencenumber' => { 8 => 0x9, 46 => 0x1d },
    'sequenceshotinterval' => { 85 => 0x224 },
    'sequentialshot' => { 85 => 0x20e },
    'serialnumber' => { 5 => 0xc, 18 => 0x180b, 24 => [0xc354,0xfde9], 62 => [0xa0,0x1d], 67 => 0x101, 70 => 0x101a, 77 => 0x25, 86 => 0x2, 89 => 'SerialNumber' },
    'serviceidentifier' => { 35 => 0x1e },
    'setbuttonfunction' => { 10 => 0x1, 13 => 0xc },
    'setfunctionwhenshooting' => { 12 => 0x0 },
    'shadingcompensation' => { 66 => 0x50c },
    'shadingcompensation2' => { 69 => 0x1012 },
    'shadow' => { 86 => 0xe },
    'shadows' => { 24 => 0xfe52, 89 => 'Shadows' },
    'shadowscale' => { 24 => 0xc633 },
    'shadowtint' => { 89 => 'ShadowTint' },
    'sharpness' => { 0 => 0xf, 22 => 0xb, 23 => 0x21, 24 => [0xa40a,0xfe56], 25 => 0x1001, 46 => 0x6b, 49 => 0x37, 55 => 0x21, 62 => 0x6, 78 => 0x21, 86 => 0x11, 89 => 'Sharpness' },
    'sharpnessfactor' => { 70 => [0x100f,0x102a] },
    'sharpnesssetting' => { 66 => 0x506 },
    'shootingmode' => { 62 => 0x89, 77 => 0x1f, 90 => 'ShootingMode' },
    'shootingrecord' => { 18 => 0x3002 },
    'shortdocumentid' => { 34 => 0xba },
    'shortfocal' => { 0 => 0x18 },
    'shutter-aelock' => { 10 => 0x4, 12 => 0x3, 13 => 0x2 },
    'shutteraelbutton' => { 11 => 0x4 },
    'shuttercount' => { 3 => 0x1, 62 => 0xa7 },
    'shuttercurtainhack' => { 90 => 'ShutterCurtainHack' },
    'shuttercurtainsync' => { 10 => 0xf, 11 => 0xf, 12 => 0xe, 13 => 0x8 },
    'shuttermode' => { 46 => 0x1b },
    'shutterreleasemethod' => { 18 => 0x1010 },
    'shutterreleasenocfcard' => { 10 => 0x2, 11 => 0x2, 13 => 0xf },
    'shutterreleasetiming' => { 18 => 0x1011 },
    'shutterspeed' => { 90 => 'ShutterSpeed' },
    'shutterspeedvalue' => { 24 => 0x9201, 89 => 'ShutterSpeedValue' },
    'signature' => { 54 => 'signature' },
    'similarityindex' => { 34 => 0xe4 },
    'site' => { 24 => 0x84e0 },
    'sizemode' => { 40 => 0xa },
    'slices' => { 80 => 0x41a },
    'slowsync' => { 25 => 0x1030 },
    'smaxsamplevalue' => { 24 => 0x155 },
    'sminsamplevalue' => { 24 => 0x154 },
    'smoothingparameter1' => { 69 => 0x300 },
    'smoothingparameter2' => { 69 => 0x310 },
    'smoothingthreshold2' => { 69 => 0x610 },
    'smoothingthresholds' => { 69 => 0x600 },
    'smoothness' => { 24 => 0xfe57 },
    'software' => { 24 => 0x131, 76 => 'Software', 86 => 0x18, 89 => 'Software' },
    'softwareversion' => { 85 => 0x207 },
    'source' => { 34 => 0x73, 76 => 'Source', 89 => 'Source' },
    'sourceimagedirectory' => { 24 => 0xc418 },
    'sourceimagefilename' => { 24 => 0xc419 },
    'sourceimagevolumename' => { 24 => 0xc41a },
    'spatialfrequencyresponse' => { 24 => [0x920c,0xa20c], 89 => 'SpatialFrequencyResponse' },
    'spatialfrequencyresponsecolumns' => { 89 => 'SpatialFrequencyResponseColumns' },
    'spatialfrequencyresponsenames' => { 89 => 'SpatialFrequencyResponseNames' },
    'spatialfrequencyresponserows' => { 89 => 'SpatialFrequencyResponseRows' },
    'spatialfrequencyresponsevalues' => { 89 => 'SpatialFrequencyResponseValues' },
    'specialinstructions' => { 34 => 0x28 },
    'specialmode' => { 70 => 0x200, 85 => 0x200 },
    'spectralsensitivity' => { 24 => 0x8824, 89 => 'SpectralSensitivity' },
    'spotfocuspointx' => { 55 => 0x2d },
    'spotfocuspointy' => { 55 => 0x2e },
    'spothalftone' => { 80 => 0x413 },
    'spotmode' => { 77 => 0xf },
    'srgbrendering' => { 73 => 'sRGB' },
    'state' => { 89 => 'State' },
    'stonits' => { 24 => 0x923f },
    'stripbytecounts' => { 24 => 0x117 },
    'stripoffsets' => { 24 => 0x111 },
    'striprowcounts' => { 24 => 0x22f },
    'sub-location' => { 34 => 0x5c },
    'subfile' => { 38 => 0xa },
    'subfiletype' => { 24 => 0xfe },
    'subifd' => { 24 => 0x14a },
    'subifd_offset' => { 64 => 0x3 },
    'subject' => { 89 => 'Subject' },
    'subjectarea' => { 89 => 'SubjectArea' },
    'subjectcode' => { 89 => 'SubjectCode' },
    'subjectdistance' => { 24 => 0x9206, 46 => 0x3e, 89 => 'SubjectDistance' },
    'subjectdistancerange' => { 24 => 0xa40c, 89 => 'SubjectDistanceRange' },
    'subjectlocation' => { 24 => [0x9214,0xa214], 89 => 'SubjectLocation' },
    'subjectprogram' => { 55 => 0x22 },
    'subjectreference' => { 34 => 0xc },
    'subsecdatetimeoriginal' => { 90 => 'SubSecDateTimeOriginal' },
    'subsectime' => { 24 => 0x9290 },
    'subsectimedigitized' => { 24 => 0x9292 },
    'subsectimeoriginal' => { 24 => 0x9291 },
    'superimposeddisplay' => { 10 => 0xa, 12 => 0x9, 13 => 0xe },
    'supplementalcategories' => { 34 => 0x14, 89 => 'SupplementalCategories' },
    'supplementaltype' => { 37 => 0x37 },
    'switchtoregisteredafpoint' => { 11 => 0x12 },
    't4options' => { 24 => 0x124 },
    't6options' => { 24 => 0x125 },
    'targetcompressionratio' => { 16 => 0x1 },
    'targetdistancesetting' => { 18 => 0x1807 },
    'targetimagetype' => { 18 => 0x100a },
    'targetprinter' => { 24 => 0x151 },
    'technology' => { 31 => 'tech' },
    'textualdata' => { 73 => 'tEXt' },
    'thresholding' => { 24 => 0x107 },
    'thumbnailfilename' => { 18 => 0x817 },
    'thumbnailimage' => { 18 => 0x2008, 70 => 0x100, 90 => 'ThumbnailImage' },
    'thumbnaillength' => { 24 => 0x202 },
    'thumbnailoffset' => { 24 => 0x201 },
    'thumbnailresource' => { 80 => 0x409 },
    'thumbnails' => { 89 => 'Thumbnails' },
    'thumbnailsformat' => { 89 => 'ThumbnailsFormat' },
    'thumbnailsheight' => { 89 => 'ThumbnailsHeight' },
    'thumbnailsimage' => { 89 => 'ThumbnailsImage' },
    'thumbnailswidth' => { 89 => 'ThumbnailsWidth' },
    'tiff-epstandardid' => { 24 => [0x9216,0xa216] },
    'tilebytecounts' => { 24 => 0x145 },
    'tiledepth' => { 24 => 0x80e6 },
    'tilelength' => { 24 => 0x143 },
    'tileoffsets' => { 24 => 0x144 },
    'tilewidth' => { 24 => 0x142 },
    'time' => { 46 => 0x14, 49 => 0x10, 78 => 0x7 },
    'timecreated' => { 34 => 0x3c },
    'timesent' => { 35 => 0x50 },
    'timestamp' => { 18 => 0x180e },
    'timezone' => { 23 => 0x3006 },
    'timezonecode' => { 21 => 0x1 },
    'timezoneinfo' => { 21 => 0x2 },
    'timezoneoffset' => { 24 => 0x882a },
    'title' => { 76 => 'Title', 89 => 'Title' },
    'tonecomp' => { 62 => 0x81 },
    'tonecurve' => { 78 => 0x402 },
    'tonecurves' => { 78 => 0x403 },
    'totalzoom' => { 46 => 0x62 },
    'transferfunction' => { 24 => 0x12d, 89 => 'TransferFunction' },
    'transferrange' => { 24 => 0x156 },
    'transmissionreference' => { 89 => 'TransmissionReference' },
    'transparencyindicator' => { 24 => 0x84ec },
    'transparentindex' => { 80 => 0x417 },
    'tvvalue' => { 14 => 0x1 },
    'type' => { 89 => 'Type' },
    'ucrbg' => { 31 => 'bfd ' },
    'unicodealphanames' => { 80 => 0x415 },
    'uniquecameramodel' => { 24 => 0xc614 },
    'uniquedocumentid' => { 34 => 0xbb },
    'uniqueobjectname' => { 35 => 0x64 },
    'units' => { 54 => 'units' },
    'urgency' => { 34 => 0xa, 89 => 'Urgency' },
    'url' => { 44 => 'url ', 80 => 0x40b },
    'url_list' => { 80 => 0x41e },
    'usageterms' => { 89 => 'UsageTerms' },
    'useradjsba_rgbshifts' => { 24 => 0xc362 },
    'usercomment' => { 18 => 0x805, 24 => 0x9286, 89 => 'UserComment' },
    'userselectgrouptitle' => { 24 => 0xc355 },
    'usmlenselectronicmf' => { 11 => 0x7 },
    'uuid-geojp2' => { 44 => 'uuid' },
    'uuid-unknown' => { 44 => 'uuid' },
    'uuid-xmp' => { 44 => 'uuid' },
    'uuidinfo' => { 44 => 'uinf' },
    'uuidlist' => { 44 => 'ulst' },
    'validbits' => { 69 => 0x611, 70 => 0x102c },
    'variousmodes' => { 46 => 0x26 },
    'variousmodes2' => { 46 => 0x3a },
    'variprogram' => { 62 => 0xab },
    'version' => { 25 => 0x0, 89 => 'Version' },
    'versionid' => { 89 => 'VersionID' },
    'versioninfo' => { 80 => 0x421 },
    'versions' => { 89 => 'Versions' },
    'versionscomments' => { 89 => 'VersionsComments' },
    'versionsevent' => { 89 => 'VersionsEvent' },
    'versionseventaction' => { 89 => 'VersionsEventAction' },
    'versionseventinstanceid' => { 89 => 'VersionsEventInstanceID' },
    'versionseventparameters' => { 89 => 'VersionsEventParameters' },
    'versionseventsoftwareagent' => { 89 => 'VersionsEventSoftwareAgent' },
    'versionseventwhen' => { 89 => 'VersionsEventWhen' },
    'versionsmodifier' => { 89 => 'VersionsModifier' },
    'versionsmodifydate' => { 89 => 'VersionsModifyDate' },
    'versionsversion' => { 89 => 'VersionsVersion' },
    'versionyear' => { 24 => 0x194 },
    'verticalcitation' => { 27 => 0x1001 },
    'verticalcstype' => { 27 => 0x1000 },
    'verticaldatum' => { 27 => 0x1002 },
    'verticalunits' => { 27 => 0x1003 },
    'videocardgamma' => { 31 => 'vcgt' },
    'viewingconddesc' => { 31 => 'vued' },
    'viewingcondilluminant' => { 33 => 0x8 },
    'viewingcondilluminanttype' => { 33 => 0x20 },
    'viewingconditions' => { 31 => 'view' },
    'viewingcondsurround' => { 33 => 0x14 },
    'vignetteamount' => { 89 => 'VignetteAmount' },
    'vignettemidpoint' => { 89 => 'VignetteMidpoint' },
    'voicememo' => { 85 => 0x216 },
    'wangannotation' => { 24 => 0x80a4 },
    'warning' => { 91 => 'Warning' },
    'watermark' => { 80 => 0x410 },
    'watermarktype' => { 45 => 0x8 },
    'webstatement' => { 89 => 'WebStatement' },
    'whitebalance' => { 8 => 0x7, 22 => 0x7, 23 => [0x19,0x2012], 24 => [0xa403,0xfe4e], 25 => 0x1002, 46 => 0x40, 51 => 0x1a, 55 => 0x3, 62 => 0x5, 63 => 0x7, 70 => 0x1015, 77 => 0x3, 78 => 0x19, 86 => 0x7, 89 => 'WhiteBalance' },
    'whitebalancebias' => { 23 => 0x2011, 77 => 0x23 },
    'whitebalancebracket' => { 66 => 0x502 },
    'whitebalancefinetune' => { 62 => 0xb },
    'whitebalancemode' => { 78 => 0x1a },
    'whitebalancetable' => { 5 => 0xa9, 18 => 0x10a9 },
    'whitebalancetemperature' => { 66 => 0x501 },
    'whitelevel' => { 24 => 0xc61d },
    'whitepoint' => { 24 => 0x13e, 54 => 'white-point', 78 => 0x201, 89 => 'WhitePoint' },
    'whitepointx' => { 75 => 0x0 },
    'whitepointy' => { 75 => 0x1 },
    'widefocuszone' => { 55 => 0x2f },
    'widerange' => { 85 => 0x20f },
    'workflowurl' => { 80 => 0x41b },
    'workingpath' => { 80 => 0x401 },
    'worldtimelocation' => { 78 => 0x22 },
    'writer-editor' => { 34 => 0x7a },
    'x3filllight' => { 86 => 0x12 },
    'xclippathunits' => { 24 => 0x158 },
    'xml' => { 44 => 'xml ' },
    'xmldata' => { 80 => 0x3ea },
    'xmp' => { 91 => 'XMP' },
    'xpauthor' => { 24 => 0x9c9d },
    'xpcomment' => { 24 => 0x9c9c },
    'xpkeywords' => { 24 => 0x9c9e },
    'xposition' => { 24 => 0x11e },
    'xpsubject' => { 24 => 0x9c9f },
    'xptitle' => { 24 => 0x9c9b },
    'xresolution' => { 24 => 0x11a, 65 => 0x11a, 89 => 'XResolution' },
    'ycbcrcoefficients' => { 24 => 0x211, 89 => 'YCbCrCoefficients' },
    'ycbcrpositioning' => { 24 => 0x213, 65 => 0x213 },
    'ycbcrsubsampling' => { 24 => 0x212, 89 => 'YCbCrSubSampling' },
    'yclippathunits' => { 24 => 0x159 },
    'yposition' => { 24 => 0x11f },
    'yresolution' => { 24 => 0x11b, 65 => 0x11b, 89 => 'YResolution' },
    'zoom' => { 70 => 0x100d },
    'zoomedresolution' => { 0 => 0x24 },
    'zoomedresolutionbase' => { 0 => 0x25 },
    'zoomposition' => { 68 => 0x300 },
);

#++++ End automatically generated code ++++


#------------------------------------------------------------------------------
# find information for tag (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $tagID = $$lookup{$tableNum};
            my @tagIDs;
            if (ref $tagID eq 'ARRAY') {
                @tagIDs = @$tagID;
            } else {
                push @tagIDs, $tagID;
            }
            foreach $tagID (@tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        &$writeProc();
                        @infoList = GetTagInfoList($table,$tagID);
                    }
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for all tag names

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2005, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
